
(defun view 
  (sizes plot-symbol-list 
         &key supplemental-plot statistical-object (menu-title "SpreadPlot") show 
         (local-links t) (location nil)
         (size (floor (* .9 (effective-screen-size))))
         rel-widths rel-heights span-right span-down
         (data-object $) (container nil))
  (if container 
      (enable-container container)
      (setf container (send data-object :create-spreadplot-container 0)))
  (let* ((view container)
         (result)
         (plot-object-list)
         (splot))
    (dolist (plot-symbol plot-symbol-list)
            (setf result 
                  (case plot-symbol
                    (histogram-plot    (histogram-plot    $ :in view))
                    (distribution-plot (distribution-plot $ :in view))
                    (cumulative-plot   (cumulative-plot   $ :in view))
                    (comparison-plot   (comparison-plot   $ :in view))
                    (dot-plot          (dot-plot          $ :in view))
                    (scatter-plot      (scatter-plot      $ :in view))
                    (scatter-matrix    (scatter-matrix    $ :in view))
                    (spinning-plot     (spinning-plot     $ :in view))
                    (orbiting-plot     (orbiting-plot     $ :in view))
                    (line-plot         (line-plot         $ :in view))
                    (box-plot          (box-plot          $ :in view))
                    (diamond-plot      (diamond-plot      $ :in view))
                    (catbox-plot       (catbox-plot       $ :in view))
                    (paracoord-plot    (paracoord-plot    $ :in view))
                    (mosaic-plot       (mosaic-plot       $ :in view))
                    (bar-graph         (bar-graph         $ :in view))))
            (setf plot-object-list (append plot-object-list (list result))))
    (setf splot (spreadplot (matrix sizes plot-object-list)
                          :container view :style 0))
    (send splot :show-spreadplot)
    (disable-container)
    (defmeth container :close () (send self :hide-window))
    ))